[//lasso
	/*
	============================================================================
	Simple Web 2.0 with Lasso and jQuery - Yahoo! News Module
	============================================================================
	Author: Jason Huck/Core Five Creative
	Lasso Summit 2007
	----------------------------------------------------------------------------
	
	This module displays Yahoo! News headlines. The user can select from several
	available topics and the new headlines flow in via ajax. In the production
	solution, we stored the user preferences in a database. For the purposes of
	this demonstration, we're just using a long-term session.
	*/


	// start/refresh user session with 'topic' var
	session_start( -name='jquerydemo', -expires=(60 * 24 * 365));
	session_addvar('topic', -name='jquerydemo');
	
	// if no topic is stored, use default
	!var_defined('topic') ? var('topic') = 'topstories';

	// list of valid feed topics
	var('alltopics') = array(
		'Top Stories' = 'topstories',
		'U.S. National' = 'us',
		'Sept. 11' = 'sept11',
		'Terrorism' = 'terrorism',
		'Hurricane Katrina' = 'hurricanekatrina',
		'World' = 'world',
		'Mideast Conflict' = 'mideast',
		'Iraq' = 'iraq',
		'Politics' = 'politics',
		'Elections' = 'elections',
		'Business' = 'business',
		'Technology' = 'tech',
		'Sports' = 'sports',
		'Entertainment' = 'entertainment',
		'Health' = 'health',
		'Odd News' = 'oddlyenough',
		'Science' = 'science',
		'Opinion/Editorial' = 'oped',
		'Kevin Sites In The Hot Zone' = 'hotzone',
		'Crimes and Trials' = 'crimes',
		'Obituaries' = 'obits',
		'Most Emailed' = 'mostemailed',
		'Most Viewed' = 'mostviewed',
		'Most Recommended' = 'highestrated'
	);

	// define a custom tag to populate our display
	define_tag('getnews', -req='topic');	
	    protect;	    
		    local('data') = yahoo_news(#topic);
		    local('out' = string);
		
		    iterate(#data, local('i'));
			    #out += '
				<li style="background-color: #' + (loop_count % 2 == 0 ? 'D9EAFF' | 'FFF') + ';"><a href="' + #i->find('link') + '" target="_blank">' + #i->find('title') + '</a></li>
			            ';
		    /iterate;
		
			return(@#out);

		    handle_error;
		        return('This Service is not available.');
		    /handle_error;		
		/protect;
	/define_tag;

	// ajax functions
	if(request_isajax);
		protect;
			var('topic') = action_param('topic');
			content_body = getnews($topic);
			abort;	
		/protect;
	/if;

	// create dropdowns
	var('topiclist' = string);
	
	iterate($alltopics, local('i'));
		$topiclist += '
    		<option value="' + #i->second + '"' + (#i->second == $topic ? ' selected') + '>' + #i->first + '</option>
    	';
	/iterate;
	
	/* the little bit of jquery below does the following:
		1) binds a function to the "change" event of the "topicswitch" pulldown
		2) on change, sets the visibility of the "headlinethrobber" image to "visible"
		3) refreshes the contents of the "headlinelist" unordered list element
		4) hides the throbber again
		5) we manually trigger the change event on the initial page load to get
		   our first batch of headlines
	*/
]
<script type="text/javascript">	
$(function(){
	$('#topicswitch').change(function(){
		$('#headlinethrobber').css({visibility:'visible'});
		$('#headlinelist').load('./?mode=headlinenews&topic=' + this.value, function(){
			$('#headlinethrobber').css({visibility:'hidden'});
		});
	});
	
	$('#topicswitch').change();
});
</script>
<h2 class="modtitle grey" id="headlinenews">Headline News</h2>
<div class="mod pink modborder">
	<form id="newsswitcher" name="status" method="post">
		<select id="topicswitch" name="select" class="boxGreen">
[$topiclist]
		</select>
		<img id="headlinethrobber" src="lib/images/throbber.gif" width="16" height="16" align="absmiddle" />
	</form>
	<ul id="headlinelist" class="scroll">
		<li align="center" style="text-align: center;">
			<img src="lib/images/throbber_medium.gif" width="32" height="32" vspace="10" /><br />
			Loading...
		</li>
	</ul>
</div>
